//
//  BPLicenseSupport.h
//  BISubstrate
//
//  Created by Michael Clark on 10-04-20.
//  Copyright 2010 Marketcircle, Inc. All rights reserved.
//

#import <Foundation/Foundation.h>

#if !TARGET_OS_IPHONE

// Return YES if there are valid licenses installed or we are in Trial
extern BOOL BPServerValidLicenseState();

// Returns YES if we do not have any licenses installed or if we cannot access the admin DB for some reason
// Otherwise, if we have licenses installed then we are not in trial mode and this returns NO
extern BOOL BPLicenseInTrialMode();
extern BOOL BPLicenseHasTrialExpired();
extern NSDate* BPLicenseTrialExpiryDate();

#endif


extern NSInteger BPLicenseTrialDaysLeftWithExpiryDate(NSDate* expiry_date);


#if !TARGET_OS_IPHONE

extern int BPLicenseTrialDaysLeft();

extern BOOL BPIsUserAlreadyLicensed(NSString* userName, BOOL* expired);
extern BOOL BPLicenseUser(NSString* userName, BOOL* user_expired, BOOL* allConsumed, NSDate** trial_expiry);
extern BOOL BPAvailableLicenseExists();
extern BOOL BPUnlicenseUser(NSString* userName);
extern unsigned int BPNumValidLicenses();

extern BOOL BPClearLicenseUsage();

// Checks to make sure the passed in license/serial pair is a valid Billings 3.0 license - used when checking a BP upgrade license
extern BOOL BPValidBillings3License(NSString* serial, NSString* license);

#endif